#version 140
#extension GL_EXT_gpu_shader4 : enable
//fun fun fun.fsh by Veggiebob
//https://www.shadertoy.com/view/3tsXzS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.1666 //*0.314159  //*0.1666
#define iResolution u_WindowSize


#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define MAX_RERAY 16  //5
#define HIT_THRESHOLD 0.01
struct Light {
    vec3 position;
    vec3 color;
    float intensity;
};
struct Material {
    vec3 color;
    float diffuse;
    float specular;
    float reflection;
    int pi;//portal index
};
struct SDF {
    Material mat;
    float d;
};
struct Ray {
    vec3 end;
    int steps;
    float d;
    SDF sdf;
};
struct Portal {
	vec3 start;
	vec2 rot;
    int endPortal;//integer index of the ending portal
    int filled;//1 if filled, 0 if empty
    vec3 color;//color tint of portal
};
//ree kill the spacing
const int numLights = 1;
const Light lights[numLights] = Light[](
    Light(vec3(-1., 1., 1.), vec3(1.), 1.0)
    //Light(vec3(2., -1., 0.), vec3(1.), 1.0)
);
//portal definitions
const int numPortals = 2;
const Portal portals[numPortals] = Portal[](
    //vec3 start, vec2 rot, int endPortalIndex, int filled, vec3 color
	//Portal(vec3(-1.5, -0.7, 1.), vec2(0., 0.), 1, 1, vec3(0.5, 0.3, 0.)),//orange portal
    //Portal(vec3(1.5, 1., -1.), vec2(0., 0.), 0, 1, vec3(0., 0.3, 0.5))//blue portal
    Portal(vec3(-1.5, 0., -1.), vec2(0., 0.), 1, 1, vec3(0.0, 0.8, 0.0)),//green portal
    Portal(vec3(1.5, 0., -1.), vec2(0., 0.), 0, 1, vec3(0.9, 0.5, 0.5))//pink portal
);
const Material def = Material(vec3(1.0, 0.5, 0.0), 0.8, 0.5, 0.0, -1);//default material
const Material soft = Material(vec3(1.0, 0.5, 0.), 0.0, 0.0, 0.0, -1);
const Material showLight = Material(vec3(0.), 0.0, 0.0, 0.0, -1);//for showing lights
const Material object = Material(vec3(1.0, 1.0, 0.5), 0.8, 0.4, 0.0, -1);
const Material mirror = Material(vec3(1.0), 0.5, 0.0, 0.5, -1);//mirror
const Material portal = Material(vec3(1.), 0.0, 1.5, -1., 0);//portal
//yay (I made this myself)
vec2 rotate2D (vec2 p, float angle){
    return vec2(p.x*cos(angle)-p.y*sin(angle), p.y*cos(angle)+p.x*sin(angle));
}
float rand (float r) {
    return 0.5+0.5*sin(1234.+pow(r, 4.));
}
vec3 rand3 (vec3 r) {
    return vec3(rand(r.x), rand(r.y), rand(r.z));
}
//from https://www.shadertoy.com/view/Ml3SR8
mat3 lookat(vec3 from, vec3 to)
{
    vec3 f = normalize(to - from);
    vec3 _tmpr = normalize(cross(f, vec3(0.0, .999, 0.0)));
    vec3 u = normalize(cross(_tmpr, f));
    vec3 r = normalize(cross(u, f));
    return mat3(r, u, f);
}
float sq (float x) { return x*x; }
vec2 sq (vec2 v) { return v*v; }
//vec2 pow (vec2 v, float p) { return vec2(pow(v.x, p), pow(v.y, p)); }
//pretty proud of this one
//maps a 2d texture onto 3d surfaces using the normal and the position of the node
//not exact but works for all surfaces
vec2 getTexPos (vec3 p, vec3 n) {
    //return sqrt(sq(p.xz*n.y) + sq(p.xy*n.z) + sq(p.yz*n.x));
    return ((p.xz*n.y) + (p.xy*n.z) + (p.yz*n.x));
}
//thanks IQ https://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm
float sdRoundedCylinder( vec3 p, float ra, float rb, float h )
{
    vec2 d = vec2( length(p.xz)-2.0*ra+rb, abs(p.y) - h );
    return min(max(d.x,d.y),0.0) + length(max(d,0.0)) - rb;
}
float sdSphere (vec3 p, float r) {
    return length(p)-r;
}
SDF portalSDF (vec3 p, int PI) {///// portal sdf
    vec2 pa = p.xy;
    p.x = pa.y;
    p.y = pa.x;
    float sd = sdSphere(p, 0.4);//sdRoundedCylinder(p, 0.2, 0.05, 0.0);
    Material pp = portal;
    pp.pi = PI;
    return SDF(pp, sd);
}
SDF lightSDF (vec3 p, vec3 pp) {
    return SDF(showLight, length(pp-p)-0.1);
}
SDF ground (vec3 p, float h) {
    return SDF(soft, p.y-h);
}
SDF ground (vec3 p, float h, float thickness) {
    float freq = 3.;
    float displace = sin(p.x*freq)*sin(p.x*freq)*cos(p.z*freq)*cos(p.z*freq)*0.8;
    return SDF(soft, abs(p.y-h)-thickness*displace);
}
SDF sphere (vec3 p, float r) {
    return SDF(object, length(p)-r);
}
//thanks to IQ for the box sdf function
SDF box (vec3 p, vec3 b) {
    vec3 d = abs(p) - b;
	return SDF(def, length(max(d,0.0))
         + min(max(d.x,max(d.y,d.z)),0.0));
}
SDF room (vec3 p, vec3 b) {
    return SDF(soft, -box(p, b).d);
}
SDF sdfADD (SDF a, SDF b) {
    if(a.d<b.d) {
        return a;
    } else {
        return b;
    }
}
SDF boxes (vec3 p) {
    SDF bs = SDF(soft, 100000.);
    float pi = 3.14159;
    for(int i = 0; i<6; i++) {
        p.xz = rotate2D(p.xz, 2.*pi/6.);
        bs = sdfADD(bs, box(p-vec3(0.5, 0., 0.), vec3(0.1)));
    }
    return bs;
}
SDF sdf (vec3 p) {
    p.xy = rotate2D(p.xy, iTime*0.1);
    SDF s = SDF(soft, 10000.);
    for(float i = 0.; i<1.; i++)
   
	{
        p.yz = rotate2D(p.yz, p.x);
        p.xz *= cos(mod(p.x, 1.))*cos(p.z);
        s = sdfADD(s, boxes(p));
    }
    s.d-=0.05;
    //show the lights (dev)
    /*
    for(int i = 0; i<numLights; i++) {
        s = sdfADD(s, lightSDF(p, lights[i].position));
    }
*/
    /*
    for(int i = 0; i<numPortals; i++) {//portal start
        Portal por = portals[i];
        //don't draw un-filled ones
        if(por.filled==0) {
            continue;
        }
        //rotate
        vec3 rp = p-por.start;
        rp.zy = rotate2D(rp.zy, por.rot.y);
        rp.xz = rotate2D(rp.xz, por.rot.x);
        s = sdfADD(s, portalSDF(rp, i));
    }
*/
    return s;
}
Ray trace (vec3 o, vec3 r, int reray) {
    vec3 p = vec3(0.0, 0.0, 0.0);
    SDF s = SDF(def, 10000.);
    float t = 0.;
    int steps = 0;
    for(int i = 0; i<256; i++) {
        p = o+r*t;
        s = sdf(p);
        t+=s.d*0.2;
        //curve of light around portals
        if(s.mat.reflection<0.&&s.d>0.&&reray==0) {
            vec3 ppos = portals[s.mat.pi].start;
            vec3 bend = normalize(p-ppos);
            //interpolate
            float x = length(p-ppos);
            
            float bend_amount = sin(pow(0.5, x*10.-1.651)) * (1.-max(0.0,dot(p-o, p-ppos))) * 0.01;
            r = normalize(mix(r, bend, bend_amount));
        }
		
        if(s.d<HIT_THRESHOLD){
            steps = i;
            break;
        }
        if(t>10.0) {
            steps = i;
            t = 1000.;
        	break;
        }
    }
    return Ray(p, steps, t, s);
}
const float E = 0.0001;
vec3 estimateNormal (vec3 p) {
    return normalize(vec3(
        sdf(vec3(p.x+E, p.y, p.z)).d-sdf(vec3(p.x-E, p.y, p.z)).d,
        sdf(vec3(p.x, p.y+E, p.z)).d-sdf(vec3(p.x, p.y-E, p.z)).d,
        sdf(vec3(p.x, p.y, p.z+E)).d-sdf(vec3(p.x, p.y, p.z-E)).d
    ));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.y;
    vec2 mouse = iMouse.xy/iResolution.xy;
    mouse-=0.5;
    uv.x-=(iResolution.x/iResolution.y)/2.;
    uv.y-=0.5;
    uv*=2.0;
    float perspective = 0.8;
    float time = iTime*0.5;
    vec3 cam = vec3(0., 0., -2.);
    vec3 ray = normalize(vec3(uv.x*perspective, uv.y*perspective, 1.0));
    cam.zy = rotate2D(cam.zy, mouse.y*5.0);
    ray.zy = rotate2D(ray.zy, mouse.y*5.0);
    
    cam.xz = rotate2D(cam.xz, -mouse.x*10.0);
    ray.xz = rotate2D(ray.xz, -mouse.x*10.0);
    vec3 col = vec3(0.);
    
    float ambient = 0.3;
    Material m;
    Material pm;
    for(int times = 0; times<MAX_RERAY; times++) {//max reflections or teleportations
        Ray t = trace(cam, ray, times);
        m = t.sdf.mat;//the material
        vec3 norm = estimateNormal(t.end);
        vec3 tcol = m.color*ambient;
        vec3 refl = reflect(normalize(ray), norm);
        //calculate light intensity at the point for each light
        for(int i = 0; i<numLights; i++) {
            Light l = lights[i];
            vec3 toLight = normalize(l.position-t.end);
            float diffuse = max(0.0, dot(toLight, norm)*m.diffuse);
            float specular = pow(max(0.0, dot(refl, toLight)), 16.0)*m.specular;
            
            float lightAmount = (diffuse+specular);//intensity of light. Default is (diffuse+specular)
            tcol += (1.-ambient)*m.color*l.intensity*l.color*lightAmount;// /float(numLights)
        }
        tcol -= float(t.steps)*float(t.steps)*0.00004;//ao
        float fog = 1.0 / (1.0 + t.d*t.d*0.01);
        tcol*=fog;
        if(m.reflection>0.0&&times<MAX_RERAY-1) {
            ray = refl;
            //ray = normalize(ray + 0.5*ray*texture2D(iChannel0, t.end).xyz);//add distortion
            ray = normalize(ray + 0.5*ray*rand3(t.end*4.));//add distortion
            cam = t.end + ray*HIT_THRESHOLD;
            col += tcol*(1.-m.reflection);
            //* include
            for(int reach = 0; reach<16; reach++) {
                SDF s = sdf(cam);
                if(s.d<=HIT_THRESHOLD*20.) {
                    cam += ray*0.08;//(HIT_THRESHOLD-s.d)*40.;
                } else {
                    break;
                }
            }
			//*/
        } else if (m.reflection<0.) {//signifies a portal
            Portal por = portals[m.pi];//in portal
            Portal OUT = portals[por.endPortal];//out portal
            col += tcol*0.0 + 0.4*por.color*pow(1.7-dot(normalize(cam-t.end), norm), 8.);//add portal glow
            vec3 off = t.end-por.start;//offset from the original portal
            cam = OUT.start+off;//specify the new starting position after portal
            float sdd = t.sdf.d;
            ray = normalize(mix(ray, -norm, 0.0));
            for(int reach = 0; reach<20; reach++) {//leave the portal region sdf
                SDF s = sdf(cam);
                if(s.d<=HIT_THRESHOLD) {
                    cam += ray*0.2;
                } else {
                    break;
                }
            }
        } else {
            //tcol *= texture2D(iChannel2, refl).rgb;
            tcol *= texture2D(iChannel1, getTexPos(t.end, norm)*.1).r;//texture everything
            if(pm.reflection>0.0) {
            	col = col*(1.-pm.reflection) + tcol*(pm.reflection);
            } else {
                col += tcol;
            }
            break;
        }
        pm = m;
    }
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}



